/*
 * Decompiled with CFR 0.152.
 */
package robotsfights.robot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import robotsfights.robot.Body;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Robot {
    private Body body;
    private Point2D position;
    private int speedX;
    private int speedY;
    private String name;
    private int life;
    private int force;
    private int resistance;

    public Robot(int width, int height, Color color, String name) {
        this.body = new Body(width, height, color, color);
        this.life = 100;
        this.resistance = 1;
        this.force = 3;
        this.name = name;
    }

    public void move() {
        this.setLocation((int)this.getLocation().getX() + this.getSpeedX(), (int)this.getLocation().getY() + this.getSpeedY());
    }

    public int getSpeedX() {
        return this.speedX;
    }

    public void setSpeedX(int speedX) {
        this.speedX = speedX;
    }

    public int getSpeedY() {
        return this.speedY;
    }

    public void setSpeedY(int speedY) {
        this.speedY = speedY;
    }

    public Body getBody() {
        return this.body;
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(int x, int y) {
        this.position = new Point2D.Float(x, y);
    }

    public Point2D getLocation() {
        return this.position;
    }

    public boolean collision(List<Robot> robots) {
        for (Robot r : robots) {
            if (!this.getBody().intersects(r.getBody().getBounds2D())) continue;
            int sX = this.getSpeedX();
            int sY = this.getSpeedY();
            this.setSpeedX(r.getSpeedX());
            this.setSpeedY(r.getSpeedY());
            r.setSpeedX(sX);
            r.setSpeedY(sY);
            if (this != r) {
                r.setLife(r.getLife() - this.getForce() + r.getResistance());
                this.setLife(this.getLife() - r.getForce() + this.getResistance());
                r.move();
                this.move();
                return true;
            }
            return false;
        }
        return false;
    }

    public void draw(Graphics2D g) {
        Ellipse2D.Float rightInternalEye;
        Ellipse2D.Float leftInternalEye;
        this.body.setPosition((float)this.position.getX(), (float)this.position.getY());
        this.body.draw(g);
        g.setColor(Color.WHITE);
        Ellipse2D.Float leftEye = new Ellipse2D.Float((float)(this.getBody().getCenterX() - 8.0), (float)(this.getBody().getY() - 4.0), 8.0f, 8.0f);
        Ellipse2D.Float rightEye = new Ellipse2D.Float((float)this.getBody().getCenterX(), (float)(this.getLocation().getY() - 4.0), 8.0f, 8.0f);
        g.fill(leftEye);
        g.fill(rightEye);
        if (this.life < 20) {
            leftInternalEye = new Ellipse2D.Float((float)(this.getBody().getCenterX() - 8.0), (float)(this.getBody().getY() - 2.0), 8.0f, 4.0f);
            rightInternalEye = new Ellipse2D.Float((float)this.getBody().getCenterX(), (float)(this.getBody().getY() - 2.0), 8.0f, 4.0f);
            g.setColor(Color.red);
        } else {
            leftInternalEye = new Ellipse2D.Float((float)(this.getBody().getCenterX() - 6.0 + (double)Integer.parseInt(this.speedX < 0 ? "-2" : (this.speedX > 0 ? "2" : "0"))), (float)(this.getBody().getY() - 2.0 + (double)Integer.parseInt(this.speedY < 0 ? "-2" : (this.speedY > 0 ? "2" : "0"))), 4.0f, 4.0f);
            rightInternalEye = new Ellipse2D.Float((float)(this.getBody().getCenterX() + 2.0 + (double)Integer.parseInt(this.speedX < 0 ? "-2" : (this.speedX > 0 ? "2" : "0"))), (float)(this.getBody().getY() - 2.0 + (double)Integer.parseInt(this.speedY < 0 ? "-2" : (this.speedY > 0 ? "2" : "0"))), 4.0f, 4.0f);
            g.setColor(Color.black);
        }
        g.fill(leftInternalEye);
        g.fill(rightInternalEye);
        g.setColor(this.body.getBorderColor());
        g.drawString(this.getName(), (int)this.getLocation().getX(), (int)(this.getLocation().getY() - 10.0));
        g.setColor(Color.green);
        g.fill(new Rectangle2D.Float((float)this.getLocation().getX() + 1.0f, (float)(this.getLocation().getY() + this.body.getHeight()), (float)((this.body.getWidth() - 2.0) / 100.0 * (double)this.life), 4.0f));
    }

    public int getForce() {
        return this.force;
    }

    public void setForce(int force) {
        this.force = force;
    }

    public int getLife() {
        return this.life;
    }

    public void setLife(int life) {
        this.life = life;
    }

    public int getResistance() {
        return this.resistance;
    }

    public void setResistance(int resistance) {
        this.resistance = resistance;
    }
}

