/*
 * Copyright MalchroSoft - Aymeric MALCHROWICZ. All right reserved.
 * The source code that contains this comment is an intellectual property
 * of MalchroSoft [Aymeric MALCHROWICZ]. Use is subject to licence terms.
 */

package robotsfights.robot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

/**
 *
 * @author Aymeric Malchrowicz
 */
public class Body extends RoundRectangle2D.Float
{
    public static int MAX_LENGTH = 20;
    public static int MIN_LENGTH = 5;

    private Color bgColor;
    private Color borderColor;

    private Point2D position;

    public Body(int width, int height, Color bgColor, Color borderColor)
    {
        super();
        if (width > MAX_LENGTH) this.width = MAX_LENGTH;
        else if (width < MIN_LENGTH) this.width = MIN_LENGTH;
        else this.width = width;
        if (height > MAX_LENGTH) this.height = MAX_LENGTH;
        else if (height < MIN_LENGTH) this.height = MIN_LENGTH;
        else this.height = height;
        this.bgColor = bgColor;
        this.borderColor = borderColor;
        this.position = new Point2D.Float(0f, 0f);
        this.setRoundRect(this.position.getX(), this.position.getY(), this.width, this.height, 4, 4);
    }

    public void setPosition(float x, float y)
    {
        this.position = new Point2D.Float(x, y);
        this.setRoundRect(this.position.getX(), this.position.getY(), this.width, this.height, 4, 4);
    }

    public Color getBgColor()
    {
        return bgColor;
    }

    public Color getBorderColor()
    {
        return borderColor;
    }


    public void draw(Graphics2D g)
    {
        g.setColor(bgColor);
        g.fill(this);
    }


}
