/*
 * Decompiled with CFR 0.152.
 */
package com.malchrosoft.filesorter.graphic;

import com.malchrosoft.debug.Log;
import com.malchrosoft.filesorter.DirectoryAnalyzer;
import com.malchrosoft.filesorter.graphic.AppMainFrame;
import com.malchrosoft.filesorter.graphic.ConsoleViewManager;
import com.malchrosoft.filesorter.graphic.DirectoryChooser;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.html.HTMLEditorKit;

public final class MainFrameController {
    private final AppMainFrame frame;
    private DirectoryAnalyzer analizer;
    private boolean launched = false;
    private ConsoleViewManager console;
    private DirectoryChooser directoryChooser;

    public MainFrameController(AppMainFrame frame) {
        this.frame = frame;
        this.frame.getConsoleView().setDocument(new DefaultStyledDocument());
        this.frame.getConsoleView().setEditorKit(new HTMLEditorKit());
        this.console = new ConsoleViewManager((HTMLEditorKit)frame.getConsoleView().getEditorKit(), frame.getConsoleView().getDocument());
        this.directoryChooser = new DirectoryChooser(null);
        this.initListeners();
        this.setProgress(0);
        this.setStatus("No directory selected");
    }

    private void initListeners() {
        this.frame.getAnalyzeButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Analyse Button ");
                MainFrameController.this.analyse();
            }
        });
        this.frame.getSortButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Sort Button");
                MainFrameController.this.sort();
            }
        });
        this.frame.getCleanButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Clean Button");
                MainFrameController.this.clean();
            }
        });
        this.frame.getDirectoryButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Directory Button");
                MainFrameController.this.loadDirectory();
            }
        });
        this.frame.getEstimateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Estimate Button");
                MainFrameController.this.estimate();
            }
        });
        this.frame.getClearConsoleButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Clear console...");
                MainFrameController.this.clearConsole();
            }
        });
        this.frame.getVerboseButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Log.debug("--- Verbose -> " + ((JToggleButton)e.getSource()).isSelected());
                MainFrameController.this.analizer.setVerbose(((JToggleButton)e.getSource()).isSelected());
            }
        });
    }

    public void setActionButtonEnabled(boolean enabled) {
        this.frame.getEstimateButton().setEnabled(enabled);
        this.frame.getAnalyzeButton().setEnabled(enabled);
        this.frame.getSortButton().setEnabled(enabled);
        this.frame.getCleanButton().setEnabled(enabled);
    }

    public void launch() {
        this.frame.setDefaultCloseOperation(3);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrameController.this.frame.setVisible(true);
                MainFrameController.this.launched = true;
                MainFrameController.this.loadDirectory();
            }
        });
    }

    public void loadDirectory() {
        if (!this.launched) {
            return;
        }
        this.directoryChooser.show(this.frame);
        if (this.directoryChooser.getSelectedDirectory() == null) {
            return;
        }
        this.analizer = new DirectoryAnalyzer(this.directoryChooser.getSelectedDirectory(), true);
    }

    public void clearConsole() {
        this.frame.getConsole().setText("");
        this.frame.getConsoleView().setText("");
    }

    public void estimate() {
        if (this.analizer == null) {
            this.getConsole().append("No root directory selected !");
            return;
        }
        this.setActionButtonEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MainFrameController.this.analizer.estimateFileCount();
                MainFrameController.this.setActionButtonEnabled(true);
            }
        }).start();
    }

    public void analyse() {
        if (this.launched && this.analizer != null) {
            this.setActionButtonEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    MainFrameController.this.analizer.analyse();
                    MainFrameController.this.setActionButtonEnabled(true);
                }
            }).start();
        } else {
            this.getConsole().append("No root directory selected !");
        }
    }

    public final void sort() {
        if (this.analizer == null) {
            this.getConsole().append("No root directory selected !");
            return;
        }
        this.setActionButtonEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MainFrameController.this.analizer.sort();
                MainFrameController.this.setActionButtonEnabled(true);
            }
        }).start();
    }

    public final void clean() {
        if (this.analizer == null) {
            this.getConsole().append("No root directory selected !");
            return;
        }
        this.setActionButtonEnabled(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MainFrameController.this.analizer.clean();
                MainFrameController.this.setActionButtonEnabled(true);
            }
        }).start();
    }

    public ConsoleViewManager getConsoleViewManager() {
        return this.console;
    }

    public JTextArea getConsole() {
        return this.frame.getConsole();
    }

    public void setStatus(String status) {
        this.frame.getStatusBarLabel().setText(status);
    }

    public void setProgress(int percent) {
        this.frame.getProgressBar().setValue(percent);
    }

    public void setProgressIndeterminate(boolean indeterminate) {
        this.frame.getProgressBar().setIndeterminate(indeterminate);
    }
}

